function [H_f1, H_f2, Hc_OK, ...
      Hc_Next, Hc_Last, Hc_This, Hc_Enter, Hc_Quit,  ...
      Hc_Weather, Hc_Velocity, Hc_Accel, Hc_HarmAcc, Hc_Residual, ...
      Hc_Temp, Hc_Prec, Hc_CaseNo] = ...
      dailysetup(station)

%  figure for plotting

H_f1 = figure;
left=50; bottom=50; width=700; height=500;
Position1 = [left, bottom, width, height];
set(H_f1,'Position', Position1)

%  figure for case and plot selection menu

H_f2 = figure;
left = left+750; width=200; bottom=350; height=200;
Position2 = [left, bottom, width, height];
set(H_f2,'Position', Position2,'MenuBar',menubar)

%  OK pushbutton for launching plot

Hc_OK = uicontrol(H_f2,       ...
   'Style',    'pushbutton',  ...
   'Position', [80,10,40,20], ...
   'String',   'OK',          ...
   'CallBack', [ ...
      'station=dailyplot(station, H_f1,',              ...
      'Hc_Next, Hc_Last, Hc_This, Hc_Enter, Hc_Quit,',   ...
      'Hc_Weather, Hc_Velocity, Hc_Accel, Hc_HarmAcc, Hc_Residual,', ...
      'Hc_Temp, Hc_Prec, Hc_CaseNo);']);

%  radiobuttons for index of next case

Hc_Next = uicontrol(H_f2,      ...
   'Style', 'radiobutton',     ...
   'Position', [20,180,50,10], ...
   'String', 'Next',           ...
   'Value', 0,                 ...
   'CallBack', [...
      'set(Hc_Next,  ''Value'',1),' ...
      'set(Hc_Last,  ''Value'',0),' ...
      'set(Hc_This,  ''Value'',0),' ...
      'set(Hc_Enter, ''Value'',0),' ...
      'set(Hc_Quit,  ''Value'',0);']);
Hc_Last = uicontrol(H_f2,      ...
   'Style', 'radiobutton',     ...
   'Position', [20,160,50,10], ...
   'String', 'Last',           ...
   'Value', 0,                 ...
   'CallBack', [...
      'set(Hc_Next,  ''Value'',0),' ...
      'set(Hc_Last,  ''Value'',1),' ...
      'set(Hc_This,  ''Value'',0),' ...
      'set(Hc_Enter, ''Value'',0),' ...
      'set(Hc_Quit,  ''Value'',0);']);
Hc_This = uicontrol(H_f2,      ...
   'Style', 'radiobutton',     ...
   'Position', [20,140,50,10], ...
   'String', 'This',           ...
   'Value', 0,                 ...
   'CallBack', [...
      'set(Hc_Next,  ''Value'',0),' ...
      'set(Hc_Last,  ''Value'',0),' ...
      'set(Hc_This,  ''Value'',1),' ...
      'set(Hc_Enter, ''Value'',0),' ...
      'set(Hc_Quit,  ''Value'',0);']);
Hc_Enter = uicontrol(H_f2,      ...
   'Style', 'radiobutton',     ...
   'Position', [20,120,50,10], ...
   'String', 'Enter',           ...
   'Value', 1,                 ...
   'CallBack', [...
      'set(Hc_Next,  ''Value'',0),' ...
      'set(Hc_Last,  ''Value'',0),' ...
      'set(Hc_This,  ''Value'',0),' ...
      'set(Hc_Enter, ''Value'',1),' ...
      'set(Hc_Quit,  ''Value'',0);']);
Hc_Quit = uicontrol(H_f2,      ...
   'Style', 'radiobutton',     ...
   'Position', [20,100,50,10], ...
   'String', 'Quit;',           ...
   'Value', 0,                 ...
   'CallBack', [...
      'set(Hc_Next,  ''Value'',0),' ...
      'set(Hc_Last,  ''Value'',0),' ...
      'set(Hc_This,  ''Value'',0),' ...
      'set(Hc_Enter, ''Value'',0),' ...
      'set(Hc_Quit,  ''Value'',1);']);

%  radiobuttons for derivative

Hc_Weather = uicontrol(H_f2,     ...
   'Style', 'radiobutton',      ...
   'Position', [100,180,80,10], ...
   'String', 'Weather',          ...
   'Value', 1,                  ...
   'CallBack', [...
      'set(Hc_Weather,  ''Value'',1),', ...
      'set(Hc_Velocity, ''Value'',0),', ...
      'set(Hc_Accel,    ''Value'',0),', ...
      'set(Hc_HarmAcc,  ''Value'',0),', ...
      'set(Hc_Residual, ''Value'',0),']);
Hc_Velocity = uicontrol(H_f2,   ...
   'Style', 'radiobutton',      ...
   'Position', [100,160,80,10], ...
   'String', 'Velocity',        ...
   'Value', 0,                  ...
   'CallBack', [...
      'set(Hc_Weather,  ''Value'',0),', ...
      'set(Hc_Velocity, ''Value'',1),', ...
      'set(Hc_Accel,    ''Value'',0),', ...
      'set(Hc_HarmAcc,  ''Value'',0),', ...
      'set(Hc_Residual, ''Value'',0),']);
Hc_Accel = uicontrol(H_f2,      ...
   'Style',    'radiobutton',   ...
   'Position', [100,140,80,10], ...
   'String',   'Acceleration',  ...
   'Value',    0,               ...
   'CallBack', [...
      'set(Hc_Weather,  ''Value'',0),', ...
      'set(Hc_Velocity, ''Value'',0),', ...
      'set(Hc_Accel,    ''Value'',1),', ...
      'set(Hc_HarmAcc,  ''Value'',0),', ...
      'set(Hc_Residual, ''Value'',0),']);
Hc_HarmAcc = uicontrol(H_f2,      ...
   'Style',    'radiobutton',   ...
   'Position', [100,120,80,10], ...
   'String',   'Harmonic Accel.',  ...
   'Value',    0,               ...
   'CallBack', [...
      'set(Hc_Weather,  ''Value'',0),', ...
      'set(Hc_Velocity, ''Value'',0),', ...
      'set(Hc_Accel,    ''Value'',0),', ...
      'set(Hc_HarmAcc,  ''Value'',1),', ...
      'set(Hc_Residual, ''Value'',0),']);
Hc_Residual = uicontrol(H_f2,      ...
   'Style',    'radiobutton',   ...
   'Position', [100,100,80,10], ...
   'String',   'Residual',  ...
   'Value',    0,               ...
   'CallBack', [...
      'set(Hc_Weather,  ''Value'',0),', ...
      'set(Hc_Velocity, ''Value'',0),', ...
      'set(Hc_Accel,    ''Value'',0),', ...
      'set(Hc_HarmAcc,  ''Value'',0),', ...
      'set(Hc_Residual, ''Value'',1),']);

%  checkboxes for variable

Hc_Temp = uicontrol(H_f2,      ...
   'Style',    'checkbox',  ...
   'Position', [20,40,50,10],  ...
   'String',   'Temp');
      
Hc_Prec = uicontrol(H_f2,    ...
   'Style',    'checkbox',  ...
   'Position', [100,40,50,10], ...
   'String',   'Prec');


%  editable text box for case number

Hc_CaseNo = uicontrol(H_f2,    ...
   'Style',    'edit',         ...
   'Position', [100,70,75,20], ...
   'String',   num2str(station), ...
   'Value',    station);
