function varargout = AMD_GUI(varargin)
% AMD_GUI M-file for AMD_GUI.fig
%      AMD_GUI, by itself, creates a new AMD_GUI or raises the existing
%      singleton*.
%
%      H = AMD_GUI returns the handle to a new AMD_GUI or the handle to
%      the existing singleton*.
%
%      AMD_GUI('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in AMD_GUI.M with the given input arguments.
%
%      AMD_GUI('Property','Value',...) creates a new AMD_GUI or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before AMD_GUI_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to AMD_GUI_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Last Modified by GUIDE v2.5 14-Feb-2011 21:31:38

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @AMD_GUI_OpeningFcn, ...
                   'gui_OutputFcn',  @AMD_GUI_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT

% --- Executes just before AMD_GUI is made visible.
function AMD_GUI_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to AMD_GUI (see VARARGIN)

set(handles.samplingTimesProvidedTag, 'Value', 1)
set(handles.caseIdProvidedTag, 'Value', 1)
set(handles.groupProvidedTag, 'Value', 1)
set(handles.lambdaHeuristicTag, 'Value', 1)
set(handles.RUN_AMD, 'Enable', 'off');

% Choose default command line output for AMD_GUI
handles.output = hObject;
handles.data = [];
handles.sample_times = [];
handles.subject_ids = [];
handles.group_ids = [];

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes AMD_GUI wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = AMD_GUI_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;

% --- Executes on button press in CONTIG.
function RUN_AMD_Callback(hObject, eventdata, handles)
% hObject    handle to RUN_AMD (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

FDADirName = get(handles.FDALibraryTag, 'String');
AMDDirName = get(handles.AMDLibraryTag, 'String');
addpath(FDADirName)
addpath(AMDDirName)

global_constants;

ncase = str2num(get(handles.ncasesTag,'String'));

if (ncase == 0)
    errordlg('Load valid input data before running simulation', 'error', 'modal')
else
    set(hObject, 'Enable', 'off')
    set(handles.statusTag, 'String', 'AMD is running, please wait...')
    simulation_parameters = simulation_parameters_template;

    simulation_parameters(1).title = get(handles.titleTag,'String');
    simulation_parameters.subject_ids = handles.subject_ids;
    simulation_parameters.sample_ts = handles.sample_times;
    simulation_parameters.x_label = get(handles.XaxisLabelTag,'String');

    simulation_parameters.sample_ys = handles.data;
    simulation_parameters.y_label = get(handles.YaxisLabelTag,'String');

    simulation_parameters.group_ids = handles.group_ids;
    uniqueGroups = unique(handles.group_ids);

    group_labels = get(handles.GroupLabelsTag,'String');
    if isempty(group_labels)
        for i=1:size(uniqueGroups,1)
            group_labels = [group_labels; {['Group_', num2str(i)]}];
        end
    else
        if (size(group_labels,1) ~= size(uniqueGroups,1))
            errordlg(['The number of group labels provided must be equal to ', num2str(size(uniqueGroups,1)), ...
                ' to match the number of groups in the data file. Provide correct number before running AMD again.'], ...
                'error', 'modal');
            set(handles.statusTag, 'String', 'Error encountered - Please fix and run again')
            set(hObject, 'Enable', 'on')
            return
        end
    end
    simulation_parameters.group_labels = group_labels;

    simulation_parameters.ncase = ncase;

    simulation_parameters.degree = str2num(get(handles.degreeTag,'String'));
    simulation_parameters.pvalue = str2num(get(handles.pValueTag,'String'));
    simulation_parameters.error_level = str2num(get(handles.errorLevelTag,'String'));
    simulation_parameters.output_all_maxima = get(handles.allMaximaTag,'Value'); 

    simulation_parameters.lambda_fct    = str2num(get(handles.lambdaFunctionTag,'String'));
    simulation_parameters.lambda_stderr = str2num(get(handles.lambdaErrorTag,'String'));

    simulation_parameters.compute_std_errors = get(handles.stdErrorTag,'Value');
    simulation_parameters.boot_samples = str2num(get(handles.bootSamplesTag,'String'));
    
    resultsDir = get(handles.outputDirectoryTag, 'String');
    
    significant_spurts_data = [];

    for id=1:simulation_parameters.ncase
        % output curve to file
        [spurt_data graph_handle] = find_spurts(simulation_parameters, id);
    %    figure(graph_handle);
        significant_spurts_data = [significant_spurts_data spurt_data];
        group = simulation_parameters.group_ids(id);  % retrieving group for this case
        fileName = [resultsDir, 'case_', num2str(simulation_parameters.subject_ids(id)), '_' ...
            char(simulation_parameters.group_labels(group)), '.png'];
        
        spurtsFound = size(significant_spurts_data,2);
        set(handles.spurtsFoundTag, 'String', num2str(spurtsFound))

        
        print('-f', '-dpng',  fileName);
        close
    end

    % output data to file
    data_file_name = [resultsDir, 'AMD_spurts.txt'];
    output_significant_data(data_file_name, significant_spurts_data, ...
        simulation_parameters.compute_std_errors);

    % plot data
    h = plot_spurts(significant_spurts_data, simulation_parameters, SORT_CASE_ID);
    %figure (h)
    print('-f', '-dpng',  [resultsDir,'spurts.png']);
    close

    set(hObject, 'Enable', 'on')
    set(handles.statusTag, 'String', 'Completed - see results in Output directory')
end


% --------------------------------------------------------------------
function CloseMenuItem_Callback(hObject, eventdata, handles)
% hObject    handle to CloseMenuItem (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
selection = questdlg(['Close ' get(handles.figure1,'Name') '?'],...
                     ['Close ' get(handles.figure1,'Name') '...'],...
                     'Yes','No','Yes');
if strcmp(selection,'No')
    return;
end

delete(handles.figure1)


% --------------------------------------------------------------------
% --- Executes on button press in ExitBtn.
function ExitBtn_Callback(hObject, eventdata, handles)
% hObject    handle to ExitBtn (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
selection = questdlg(['Close ' get(handles.figure1,'Name') '?'],...
                     ['Close ' get(handles.figure1,'Name') '...'],...
                     'Yes','No','Yes');
if strcmp(selection,'No')
    return;
end

delete(handles.figure1)

% --- Executes on button press in LoadInputTag.
function LoadInputTag_Callback(hObject, eventdata, handles)
% hObject    handle to LoadInputTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
[inputDataFile pathName] = uigetfile('*.dat');

if (inputDataFile ~= 0)
    full_data = load([pathName, inputDataFile]);
    data = full_data;
    if (get(handles.samplingTimesProvidedTag, 'Value') == 1)
        data(1,:) = [];  % first row is sample times, so drop
    end
    if (get(handles.groupProvidedTag, 'Value') == 1)
        data(:,2) = [];  % second column is group id, so drop
    end
    if (get(handles.caseIdProvidedTag, 'Value') == 1)
        data(:,1) = [];  % first column is subject id, so drop
    end
    
    [ncase nsamples] = size(data);

    if (get(handles.samplingTimesProvidedTag, 'Value') == 1)
        startIndex = size(full_data,2)-nsamples+1;
        sample_times = full_data(1,startIndex:end);
    else
        sample_times = [1:nsamples];
    end
    
    if (get(handles.caseIdProvidedTag, 'Value') == 1)
        startIndex = size(full_data,1)-ncase+1;
        subject_ids = full_data(startIndex:end,1);
    else
        subject_ids = [1:ncase]';
    end
    
    if (get(handles.groupProvidedTag, 'Value') == 1)
        startIndex = size(full_data,1)-ncase+1;
        group_ids = full_data(startIndex:end,2);
    else
        group_ids = ones(ncase,1);
    end
    
    uniqueGroups = unique(group_ids);
    if (max(uniqueGroups) > size(uniqueGroups,1))
        errordlg(['Invalid group id found. The largest group id (here: ', num2str(max(uniqueGroups)), ...
            ') should not exceed the number of groups in the data file file (here: ', num2str(size(uniqueGroups,1)), ')'], ...
            'error', 'modal');
        return
    end
    
    if (get(handles.missingDataTag, 'Value') == 1)
        % replace missing data (values = -1) by the last known value
        for caseid=1:size(data,1)
            last_value = 0;
            for sampleid=1:size(data,2)
                if(data(caseid,sampleid) == -1)
                    data(caseid,sampleid) = last_value;
                else
                    last_value = data(caseid,sampleid);
                end
            end
        end
    end

    set(handles.ncasesTag, 'String', num2str(ncase));
    set(handles.samplesCountTag, 'String', num2str(size(sample_times,1)));
    set(handles.groupsCountTag, 'String', num2str(size(unique(group_ids),1)));

    if (get(handles.lambdaHeuristicTag, 'Value') == 1)
        lambda = size(sample_times,1).^3/1e5;
        set(handles.lambdaFunctionTag,'String', num2str(lambda));
        set(handles.lambdaErrorTag,'String', num2str(lambda));
    end

    
    set(handles.RUN_AMD, 'Enable', 'on');
    set(handles.statusTag, 'String', 'Ready to run AMD')

    handles.data = data';
    handles.sample_times = sample_times;
    handles.subject_ids = subject_ids;
    handles.group_ids = group_ids;

    guidata(hObject, handles)
end

function ncasesTag_Callback(hObject, eventdata, handles)
% hObject    handle to ncasesTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of ncasesTag as text
%        str2double(get(hObject,'String')) returns contents of ncasesTag as a double


% --- Executes during object creation, after setting all properties.
function ncasesTag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to ncasesTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function titleTag_Callback(hObject, eventdata, handles)
% hObject    handle to titleTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of titleTag as text
%        str2double(get(hObject,'String')) returns contents of titleTag as a double


% --- Executes during object creation, after setting all properties.
function titleTag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to titleTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function XaxisLabelTag_Callback(hObject, eventdata, handles)
% hObject    handle to XaxisLabelTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of XaxisLabelTag as text
%        str2double(get(hObject,'String')) returns contents of XaxisLabelTag as a double


% --- Executes during object creation, after setting all properties.
function XaxisLabelTag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to XaxisLabelTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function YaxisLabelTag_Callback(hObject, eventdata, handles)
% hObject    handle to YaxisLabelTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of YaxisLabelTag as text
%        str2double(get(hObject,'String')) returns contents of YaxisLabelTag as a double


% --- Executes during object creation, after setting all properties.
function YaxisLabelTag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to YaxisLabelTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function degreeTag_Callback(hObject, eventdata, handles)
% hObject    handle to degreeTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of degreeTag as text
%        str2double(get(hObject,'String')) returns contents of degreeTag as a double


% --- Executes during object creation, after setting all properties.
function degreeTag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to degreeTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function pValueTag_Callback(hObject, eventdata, handles)
% hObject    handle to pValueTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of pValueTag as text
%        str2double(get(hObject,'String')) returns contents of pValueTag as a double


% --- Executes during object creation, after setting all properties.
function pValueTag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to pValueTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function errorLevelTag_Callback(hObject, eventdata, handles)
% hObject    handle to errorLevelTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of errorLevelTag as text
%        str2double(get(hObject,'String')) returns contents of errorLevelTag as a double


% --- Executes during object creation, after setting all properties.
function errorLevelTag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to errorLevelTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in allMaximaTag.
function allMaximaTag_Callback(hObject, eventdata, handles)
% hObject    handle to allMaximaTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of allMaximaTag

% --- Executes on button press in stdErrorTag.
function stdErrorTag_Callback(hObject, eventdata, handles)
% hObject    handle to stdErrorTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of stdErrorTag

flag = get(hObject,'Value');
if (flag == true)
    set(handles.bootSamplesTag, 'enable', 'on')
else
    set(handles.bootSamplesTag, 'enable', 'off')
end

function bootSamplesTag_Callback(hObject, eventdata, handles)
% hObject    handle to bootSamplesTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of bootSamplesTag as text
%        str2double(get(hObject,'String')) returns contents of bootSamplesTag as a double


% --- Executes during object creation, after setting all properties.
function bootSamplesTag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to bootSamplesTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function lambdaFunctionTag_Callback(hObject, eventdata, handles)
% hObject    handle to lambdaFunctionTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of lambdaFunctionTag as text
%        str2double(get(hObject,'String')) returns contents of lambdaFunctionTag as a double


% --- Executes during object creation, after setting all properties.
function lambdaFunctionTag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to lambdaFunctionTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function lambdaErrorTag_Callback(hObject, eventdata, handles)
% hObject    handle to lambdaErrorTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of lambdaErrorTag as text
%        str2double(get(hObject,'String')) returns contents of lambdaErrorTag as a double


% --- Executes during object creation, after setting all properties.
function lambdaErrorTag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to lambdaErrorTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function outputDirectoryTag_Callback(hObject, eventdata, handles)
% hObject    handle to outputDirectoryTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of outputDirectoryTag as text
%        str2double(get(hObject,'String')) returns contents of outputDirectoryTag as a double


% --- Executes during object creation, after setting all properties.
function outputDirectoryTag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to outputDirectoryTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in OutputDirectoryBrowserTag.
function OutputDirectoryBrowserTag_Callback(hObject, eventdata, handles)
% hObject    handle to OutputDirectoryBrowserTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
currentDirName = get(handles.outputDirectoryTag, 'String');
dirName = uigetdir(currentDirName);
set(handles.outputDirectoryTag, 'String', dirName);



function FDALibraryTag_Callback(hObject, eventdata, handles)
% hObject    handle to FDALibraryTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of FDALibraryTag as text
%        str2double(get(hObject,'String')) returns contents of FDALibraryTag as a double


% --- Executes during object creation, after setting all properties.
function FDALibraryTag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to FDALibraryTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function AMDLibraryTag_Callback(hObject, eventdata, handles)
% hObject    handle to AMDLibraryTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of AMDLibraryTag as text
%        str2double(get(hObject,'String')) returns contents of AMDLibraryTag as a double


% --- Executes during object creation, after setting all properties.
function AMDLibraryTag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to AMDLibraryTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in FDALibraryBrowseTag.
function FDALibraryBrowseTag_Callback(hObject, eventdata, handles)
% hObject    handle to FDALibraryBrowseTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
currentDirName = get(handles.FDALibraryTag, 'String');
dirName = uigetdir(currentDirName);
set(handles.FDALibraryTag, 'String', dirName);


% --- Executes on button press in AMDLibraryBrowseTag.
function AMDLibraryBrowseTag_Callback(hObject, eventdata, handles)
% hObject    handle to AMDLibraryBrowseTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
currentDirName = get(handles.AMDLibraryTag, 'String');
dirName = uigetdir(currentDirName);
set(handles.AMDLibraryTag, 'String', dirName);


% --- Executes on button press in samplingTimesProvidedTag.
function samplingTimesProvidedTag_Callback(hObject, eventdata, handles)
% hObject    handle to samplingTimesProvidedTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of samplingTimesProvidedTag


% --- Executes on button press in caseIdProvidedTag.
function caseIdProvidedTag_Callback(hObject, eventdata, handles)
% hObject    handle to caseIdProvidedTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of caseIdProvidedTag

if (get(hObject,'Value') == 1)
    set(handles.groupProvidedTag, 'Enable', 'on')
else
    set(handles.groupProvidedTag, 'Value', 0)
    set(handles.groupProvidedTag, 'Enable', 'off')
end

% --- Executes on button press in groupProvidedTag.
function groupProvidedTag_Callback(hObject, eventdata, handles)
% hObject    handle to groupProvidedTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of groupProvidedTag



function samplesCountTag_Callback(hObject, eventdata, handles)
% hObject    handle to samplesCountTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of samplesCountTag as text
%        str2double(get(hObject,'String')) returns contents of samplesCountTag as a double


% --- Executes during object creation, after setting all properties.
function samplesCountTag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to samplesCountTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function spurtsFoundTag_Callback(hObject, eventdata, handles)
% hObject    handle to spurtsFoundTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of spurtsFoundTag as text
%        str2double(get(hObject,'String')) returns contents of spurtsFoundTag as a double


% --- Executes during object creation, after setting all properties.
function spurtsFoundTag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to spurtsFoundTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in GroupLabelsTag.
function GroupLabelsTag_Callback(hObject, eventdata, handles)
% hObject    handle to GroupLabelsTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns GroupLabelsTag contents as cell array
%        contents{get(hObject,'Value')} returns selected item from GroupLabelsTag


% --- Executes during object creation, after setting all properties.
function GroupLabelsTag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to GroupLabelsTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in addTag.
function addTag_Callback(hObject, eventdata, handles)
% hObject    handle to addTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in deleteTag.
function deleteTag_Callback(hObject, eventdata, handles)
% hObject    handle to deleteTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

selected = get(handles.GroupLabelsTag,'Value');
prev_str = get(handles.GroupLabelsTag,'String');
if ~isempty(prev_str)
    prev_str(get(handles.GroupLabelsTag,'Value')) = [];
    set(handles.GroupLabelsTag, 'String', prev_str, ...
        'Value', min(selected,length(prev_str))); 
end
groups = get(handles.GroupLabelsTag, 'String');
set(handles.GroupsCountTag, 'String', num2str(size(groups,1)));

function newGroupLabelTag_Callback(hObject, eventdata, handles)
% hObject    handle to newGroupLabelTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of newGroupLabelTag as text
%        str2double(get(hObject,'String')) returns contents of newGroupLabelTag as a double

groups = get(handles.GroupLabelsTag, 'String');
groups = [groups; {get(handles.newGroupLabelTag,'String')}];
set(handles.newGroupLabelTag,'String', '')
set(handles.GroupLabelsTag, 'String', groups);
set(handles.GroupLabelsTag, 'Value', 1);
set(handles.GroupsCountTag, 'String', num2str(size(groups,1)));

% --- Executes during object creation, after setting all properties.
function newGroupLabelTag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to newGroupLabelTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function groupsCountTag_Callback(hObject, eventdata, handles)
% hObject    handle to groupsCountTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of groupsCountTag as text
%        str2double(get(hObject,'String')) returns contents of groupsCountTag as a double


% --- Executes during object creation, after setting all properties.
function groupsCountTag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to groupsCountTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in lambdaHeuristicTag.
function lambdaHeuristicTag_Callback(hObject, eventdata, handles)
% hObject    handle to lambdaHeuristicTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of lambdaHeuristicTag


% --- Executes on button press in missingDataTag.
function missingDataTag_Callback(hObject, eventdata, handles)
% hObject    handle to missingDataTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of missingDataTag



function GroupsCountTag_Callback(hObject, eventdata, handles)
% hObject    handle to GroupsCountTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of GroupsCountTag as text
%        str2double(get(hObject,'String')) returns contents of GroupsCountTag as a double


% --- Executes during object creation, after setting all properties.
function GroupsCountTag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to GroupsCountTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
