function x = getBandWidthFactor(p)
    % returns the factor for the width of the confidence bands
    % for the p value given as input
    % check that p value is valid
    % Note: symmetrical two-tailed distribution assumed
    if ((p>1) || (p<0))
        error(['Invalid p value: ' num2str(p)])
    end
    x = -sqrt(2)*erfinv(p - 1);  % if this line causes an error, input arguments do not fit. 
return;