function stderrfct = get_stderr_estimates( t, fct_fd, stderr, y2cMap, degree )
    %
    % compute standard errors for confidence bands
    %
    % For details, see Ramsay & Silverman, Functional Data Analysis, second edition, section 4.6
    %
    % Input parameters
    % ----------------
    %  t        vector of values for which we want standard errors 
    %  fct_fd   FDA object that fits the raw data
    %  stderr   An FDA standard error matrix
    %  y2cMap   A matrix produced by SMOOTH_BASIS that maps
    %           a data vector into the corresponding coefficient
    %           vector
    %  degree   Indicates which derivative of the data_fd corresponds to the
    %           base function. Generally, the base function is the 0th
    %           derivative, but in some cases it might be the first one, such
    %           as for height (growth), we might be interested in maxima of the
    %           velocity (rate of change), not maxima of the growth curve per se
    % 
    %
    % Output values
    % -------------
    % stderrfct   Vector of standard errors for x values of the degree'th derivative 

    fd_basis  = getbasis(fct_fd);
    fctbasis  = eval_basis(t, fd_basis, degree);

    % y2cMap was determined during the fitting of the data, and is a vector
    % mapping the original data values to coefficients of the basis set
    % Lmat 
    fctLmat   = fctbasis*y2cMap;

    %  compute sampling variances and covariances of acceleration
    %  estimates
    % eq. 4.10 on p. 67 section 4.7 of rough.pdf, 
    % states that the variance of a linear transformation of a random 
    % vector can be obtained by:
    stderrfct = sqrt(diag(fctLmat * diag(stderr) * fctLmat'));
return;