% This file contains global constants declarations
verbose      = false; % Display information while processing. Useful for debugging.
die_on_error = false;  % if this procedure fails to optimize the point,
                         % you can decide to exit the program in error by 
                         % setting this value to true, or you can simply
                         % return the initial estimate and continue. In the
                         % latter case, it's as though you hadn't
                         % optimized.

% classification of extrenums in a FDA curve 
MAX_FCT             = 1;  % maximum in the function
MIN_FCT             = -1; % minimum in the function
MAX_DERIV           = 2;  % maximum in the derivative
MIN_DERIV           = -2; % minimum in the derivative
BOUNDARY            = 0;  % boundary value (an end point of the vector of x values)

% for statistical significance purposes
NOT_A_MAXIMA        = 0;  % not a maxima so stat. signif. is not applicable
SIGNIFICANT         = 1;  % maxima is statistically significant
NOT_SIGNIFICANT     = -1; % maxima is not statistically significant

% types of sorts for plotting purposes
SORT_CASE_ID        = 1; % plot by increasing case id 
SORT_BEGIN_LOCATION = 2; % plot by increasing begin location of the 1st spurt
SORT_AMPLITUDE      = 3; % plot by increasing spurt amplitude 

% =========================================================================
% spurt_data_template: a structure of information about spurts (or maxima). 
% Has the following fields:
% * groupId - Group of the subject or case
% * caseId  - Spurt belongs to this subject or case
% * spurtId - Identifier of a spurt for a given subject or case
% * begin_location   - location of the beginning of the spurt
% * stderr_begin     - Standard error on the beginning estimate
% * center_location  - Spurt center location
% * stderr_center    - Standard error on the center estimate
% * amplitude        - Spurt amplitude (or intensity)
% * stderr_amplitude - Standard error on the amplitude estimate 
% * duration         - Duration of the spurt, in x axis units (e.g., time)
% * stderr_duration  - Standard error on the duration estimate
% (One entry per maximum (spurt), spurtId is used to index the structure)
%
spurt_data_template = ...
             struct('groupId', {}, ...
                    'caseId', {}, ...
                    'spurtId', {}, ...
                    'begin_location', {}, ...
                    'stderr_begin', {}, ...
                    'center_location', {}, ...
                    'stderr_center', {}, ...
                    'amplitude', {}, ...
                    'stderr_amplitude', {}, ...
                    'duration', {}, ...
                    'stderr_duration', {});

                
% =========================================================================
% simulation_parameters_template: a structure for setting simulation
%                                 parameters:
%
% * sample_y and sample_t - Vector of raw data (Y and T) where the
%               function was sampled, for an individual subject.
% * subject_id  Numerical identifier of the subject
% * group_id    The group (experimental, population, etc.) in which this curve
%               belongs
% * group_label String that serves as a label for the group (condition)
% * x_label     String to be displayed as label on graph for the t axis 
% * y_label     String to be displayed as label on graph for the y axis 
% * degree      In which derivative are we looking for maxima and minima. To
%               find max in the function, use degree = 0, and to find spurts (that is,
%               max in velocity), use degree = 1
% * lambda_fct  Smoothing parameter for the function curve (see FDA documentation for details)
% * lambda_stderr Smoothing parameter for the std error curve (see FDA documentation for details)
% * error_level   Required precision for zero crossing estimates 
%                 that is: abs(F(estimate_xvalue)) < error_level
% * compute_std_errors  set to true to compute standard errors of the
%                     estimated parameters (center, amplitude and duration)
%                     using the bootstrap method (runs slower), 
%                     or set to false to get estimated parameter values 
%                     only (runs faster).
% * output_all_maxima  set to true to generate all spurt data (including
%                      non-significant one, or set to false to output significant data only
% * boot_samples     number of boot samples to use to estimate std errors
%                   relevant only when compute_std_errors = true


                     
simulation_parameters_template = ...
    struct( 'title', {}, ...
            'sample_ys', {}, ...
            'sample_ts', {}, ...
            'subject_ids', {}, ...
            'group_ids', {}, ...
            'group_labels',{}, ...
            'x_label', {}, ...
            'y_label', {}, ...
            'degree', {}, ...
            'pvalue', {}, ...
            'lambda_fct', {}, ...
            'lambda_stderr', {}, ...
            'error_level', {}, ...
            'compute_std_errors', {}, ...
            'output_all_maxima', {}, ...
            'boot_samples', {});
        
        