function output_significant_data( file_name, significant_spurt_data, estimate_std_err)

    % Outputs spurt data to file_name
    % 
    % Input parameters
    % ----------------
    % file_name : name of file where to output data
    % significant_spurt_data : Structure of data to output, containing fields:
    %  * caseId  - Spurt belongs to this subject or case
    %  * groupId - Group of the subject or case
    %  * begin_location - x value where spurt begins
    %  * center_location - x value where center of spurt is located
    %  * stderr_location - Standard error on the location estimate
    %  * amplitude - Spurt amplitude (or intensity)
    %  * stderr_amplitude - Standard error on the amplitude estimate 
    %  * duration - Duration of the spurt, in x axis units (e.g., time)
    %  * stderr_duration - Standard error on the duration estimate
    % (one entry per significant spurt to output)
    % estimate_std_err : whether a bootstrap sample was generated and used to
    %                    compute std error

    % Note: File is opened and closed for each entry to get around the 4kb max limit
    % (It seems that Matlab cannot output more than 4kb of data at a time)

    if (estimate_std_err)
        % check if file exists
        fid = fopen(file_name, 'r');
        if (fid == -1)
            % File does not exist, so output file header 
            fid = fopen(file_name, 'w');
            fprintf(fid, 'groupID caseID spurtID beginLoc stderrorBegin centerLoc stderrCenter amplitude stderrAmp duration stderrDur\r\n');
        end
        fclose(fid);

        for id=1:size(significant_spurt_data,2)
           % output data for each spurt (i.e., each row of the
           % significant_spurt_data matrix)
           fid = fopen(file_name, 'a');
           fprintf(fid, '%i %i %i %f %f %f %f %f %f %f %f \r\n', ...
                significant_spurt_data(id).groupId, ...
                significant_spurt_data(id).caseId, ...
                significant_spurt_data(id).spurtId, ...
                significant_spurt_data(id).begin_location, ...
                significant_spurt_data(id).stderr_begin, ...
                significant_spurt_data(id).center_location, ...
                significant_spurt_data(id).stderr_center, ...
                significant_spurt_data(id).amplitude, ...
                significant_spurt_data(id).stderr_amplitude, ...
                significant_spurt_data(id).duration, ...
                significant_spurt_data(id).stderr_duration);
           fclose(fid);
        end
   else
        % check if file exists
        fid = fopen(file_name, 'r');
        if (fid == -1)
            % File does not exist, so output file header 
            fid = fopen(file_name, 'w');
            fprintf(fid, 'groupID caseID spurtID beginLoc centerLoc amplitude duration\r\n');
        end
        fclose(fid);

        for id=1:size(significant_spurt_data,2)
           % output data for each spurt (i.e., each row of the
           % significant_spurt_data matrix)
           fid = fopen(file_name, 'a');
           fprintf(fid, '%i %i %i %f %f %f %f \r\n', ...
                significant_spurt_data(id).groupId, ...
                significant_spurt_data(id).caseId, ...
                significant_spurt_data(id).spurtId, ...
                significant_spurt_data(id).begin_location, ...
                significant_spurt_data(id).center_location, ...
                significant_spurt_data(id).amplitude, ...
                significant_spurt_data(id).duration);
           fclose(fid);
        end
    end
return;