addpath ('c:\matlab7\fdaM')
addpath ('c:\matlab7\fdaM\examples\handwrit')

%  Last modified 22 March 2005

%  -----------------------------------------------------------------------
%                 Registered Handwriting Data
%  -----------------------------------------------------------------------

%  Input the data.  These handwriting functions have already been
%  registered.

fid = fopen('fdareg.dat','rt');
fdarray = reshape(fscanf(fid,'%f'), [20,2,1401]);
fdarray = permute(fdarray,[3,1,2]);
fdarray = fdarray/1000;   %  convert unit to meters

%  set up time values and range

n = 1401;
T = 2.3;
fdatime  = linspace(0, T, n)';
fdarange = [0, T];

%  Set up a basis for smoothing.  
%  Order 7 was used to get a reasonable estimate of the third deriv.

norder   = 7;
nbasis   = n + norder - 2;
fdabasis = create_bspline_basis([0, T], 205, 7);

%  smooth the data

lambda = 1e-16;
fdParobj = fdPar(fdabasis, 5, lambda);

[fdafd, df, gcv] = smooth_basis(fdatime, fdarray, fdParobj);

df
mean(mean(gcv))

plotfit_fd(fdarray, fdatime, fdafd)

fdafd_fdnames{1} = 'Seconds';
fdafd_fdnames{2} = 'Replications';
fdafd_fdnames{3} = 'mm';
fdafd = putnames(fdafd, fdafd_fdnames);

%  plot all curves

plot(fdafd)

%  compute values of curves and the values of the curve

fdamat     = eval_fd(fdafd, fdatime);
fdameanvec = squeeze(eval_fd(mean(fdafd), fdatime));

%  plot individual curves, including both sampling points and fit
%  also plot the mean curve in the background

subplot(1,1,1);
for i = 1:20
  lhdl = plot(fdarray(:,i,1),  fdarray(:,i,2),  'go', ...
              fdamat(:,i,1),   fdamat(:,i,2),   '-', ...
              fdameanvec(:,1), fdameanvec(:,2), 'r--');
  set(lhdl, 'LineWidth', 2)
  axis([-.040, .040,-.040, .040]);
  title(['\fontsize{16} Record ', num2str(i)]);
  legend('\fontsize{16} Data', ...
         '\fontsize{16} Smooth', ...
         '\fontsize{16} Mean', ...
         'Location', 'SouthEast')
  pause;
end

%  plot the velocity records

subplot(1,1,1);
for i=1:20
    veloc = squeeze(eval_fd(fdatime, fdafd(i,:), 1));
    lhdl = plot(fdatime, veloc(:,1), '-', ...
                fdatime, veloc(:,2), '-', ...
                [0,T],[0,0], 'r:');
    set(lhdl, 'LineWidth', 2)
    axis([0, T, -0.5, 0.5]);
    xlabel('\fontsize{16} Seconds')
    ylabel('\fontsize{16} meters/sec/sec')
    title(['\fontsize{16} Velocity for Curve ',num2str(i)])
    legend('X', 'Y')
    pause
end

%  plot the acceleration records

subplot(1,1,1);
for i=1:20
    accel = squeeze(eval_fd(fdatime, fdafd(i,:), 2));
    lhdl = plot(fdatime, accel(:,1), '-', ...
                fdatime, accel(:,2), '-', ...
                [0,T],[0,0], 'r:');
    set(lhdl, 'LineWidth', 2)
    axis([0, T, -10, 10]);
    xlabel('\fontsize{16} Seconds')
    ylabel('\fontsize{16} meters/sec/sec')
    title(['\fontsize{16} Acceleration for Curve ',num2str(i)])
    legend('X', 'Y')
    pause
end

%  compute the acceleration magnitudes

D2fdamat = eval_fd(fdafd, fdatime, 2);
D2mag = sqrt(D2fdamat(:,:,1).^2 + D2fdamat(:,:,2).^2);

%  plot the acceleration magnitudes

subplot(1,1,1);
lhdl = plot(fdatime, D2mag);
set(lhdl, 'LineWidth', 1)
xlabel('\fontsize{16} Seconds')
ylabel('\fontsize{16} mm/sec^2')
title('\fontsize{16} Acceleration Magnitude');
axis([0,T,0,10]);

%  plot the third derivatives or jerk

subplot(1,1,1);
for i=1:20
    jerk = squeeze(eval_fd(fdatime, fdafd(i,:), 3));
    lhdl = plot(fdatime, jerk(:,1), '-', ...
                fdatime, jerk(:,2), '-', ...
                [0,T],[0,0], 'r:');
    set(lhdl, 'LineWidth', 2)
    axis([0, T, -300, 300]);
    xlabel('\fontsize{16} Seconds')
    ylabel('\fontsize{16} meters/sec^3')
    title(['\fontsize{16} Jerk for Curve ',num2str(i)])
    legend('X', 'Y')
    pause
end

%  ----------------------------------------------------
%  Estimate a third order linear differential equation 
%  using principal differential analysis
%  ----------------------------------------------------

%  set up a basis for constant coefficients

conbasis = create_constant_basis([0,T]);
zerofd   = fd(0, conbasis);
onesfd   = fd(ones(1,20),conbasis);

%  set up cell array for output functions
%  the problem is set up as a system of two equations,
%  the first for X and the second for Y

xfdcell{1,1} = fdafd(:,1);
xfdcell{2,1} = fdafd(:,2);

%  set up 2 by 2 by 3 cell array for derivative 
%   weight functions
%  In each equation, the variable is not forced
%  by the other variable.  
%  That is, the system is diagonal.

lambda = 1e-12;

bwtcell{1,1,1} = fdPar(fdabasis, 2, lambda, 1);  
% unestimated zero constant
bwtcell{1,1,2} = fdPar(fdabasis, 2, lambda, 1);  
% estimated coefficient
bwtcell{1,1,3} = fdPar(fdabasis, 2, lambda, 1);  
% estimated coefficient

bwtcell{1,2,1} = fdPar(zerofd,   0, lambda, 0);  
% unestimated zero constant
bwtcell{1,2,2} = fdPar(zerofd,   0, lambda, 0);  
% unestimated zero constant
bwtcell{1,2,3} = fdPar(zerofd,   0, lambda, 0);  
% unestimated zero constant

bwtcell{2,1,1} = fdPar(zerofd,   0, lambda, 0);  
% unestimated zero constant
bwtcell{2,1,2} = fdPar(zerofd,   0, lambda, 0);  
% unestimated zero constant
bwtcell{2,1,3} = fdPar(zerofd,   0, lambda, 0);  
% unestimated zero constant

bwtcell{2,2,1} = fdPar(fdabasis, 2, lambda, 1);  
% unestimated zero constant
bwtcell{2,2,2} = fdPar(fdabasis, 2, lambda, 1);  
% estimated coefficient
bwtcell{2,2,3} = fdPar(fdabasis, 2, lambda, 1);  
% estimated coefficient

%  carry out the PDA

[bfdcell, afdcell, resfdcell] = pdacell(xfdcell, bwtcell);

%  plot weight functions the X equation

subplot(3,1,1)
plot(getfd(bfdcell{1,1,1}))
title('\fontsize{16} Position weight for X')
subplot(3,1,2)
plot(getfd(bfdcell{1,1,2}))
title('\fontsize{16} Velocity weight for X')
subplot(3,1,3)
plot(getfd(bfdcell{1,1,3}))
title('\fontsize{16} Acceleration weight for X')

%  plot weight functions for  the Y equation

subplot(3,1,1)
plot(getfd(bfdcell{2,2,1}))
title('\fontsize{16} Velocity weight for Y')
subplot(3,1,2)
plot(getfd(bfdcell{2,2,2}))
title('\fontsize{16} Velocity weight for Y')
subplot(3,1,3)
plot(getfd(bfdcell{2,2,3}))
title('\fontsize{16} Acceleration weight for Y')

%  plot residual functions using same
%  vertical scale as for jerk

subplot(2,1,1)
plot(resfdcell{1})
title('\fontsize{16} Residuals for X')
axis([0, T, -300, 300]);
subplot(2,1,2)
plot(resfdcell{2})
title('\fontsize{16} Residuals for Y')
axis([0, T, -300, 300]);

%  compare sums of squares of residuals with
%  sums of squares of jerk using squared
%  multiple correlations.  

jerkX    = eval_fd(fdatime, fdafd(:,1), 3);
jerkSSX  = sum(sum(jerkX.^2));
residX   = eval_fd(fdatime, resfdcell{1});
residSSX = sum(sum(residX.^2));
RsqX = (jerkSSX - residSSX)/jerkSSX

jerkY    = eval_fd(fdatime, fdafd(:,2), 3);
jerkSSY  = sum(sum(jerkY.^2));
residY   = eval_fd(fdatime, resfdcell{1});
residSSY = sum(sum(residY.^2));
RsqY = (jerkSSY - residSSY)/jerkSSY

%  solve equations for functions spanning the null space of
%  the homogeneous operator

odeoptions = [];
xstart = eye(3);

%  X - curves

Xbfdcell{1} = bfdcell{1,1,1};
Xbfdcell{2} = bfdcell{1,1,2};
Xbfdcell{3} = bfdcell{1,1,3};

xstart(1,1) = mean(eval_fd(0, fdafd(:,1), 0));
xstart(2,2) = mean(eval_fd(0, fdafd(:,1), 1));
xstart(3,3) = mean(eval_fd(0, fdafd(:,1), 2));

[tp1, xp1] = ode45(@derivcell, fdatime, xstart(:,1), odeoptions, Xbfdcell);
[tp2, xp2] = ode45(@derivcell, fdatime, xstart(:,2), odeoptions, Xbfdcell);
[tp3, xp3] = ode45(@derivcell, fdatime, xstart(:,3), odeoptions, Xbfdcell);

%  Plot solutions.  The second dimension of xarray
%  corresponds to the order of derivative in the solution,
%  ranging from 0 to 2.  

xarray = zeros(n,3,3);
xarray(:,:,1) = xp1;
xarray(:,:,2) = xp2;
xarray(:,:,3) = xp3;

for j=1:3
    subplot(3,1,1)
    plot(fdatime, xarray(:,1,j), '-', [0,T], [0,0], 'r:')
    ylabel('\fontsize{16} x')
    title(['\fontsize{16} Solution ',num2str(j)])
    subplot(3,1,2)
    plot(fdatime, xarray(:,2,j), '-', [0,T], [0,0], 'r:')
    ylabel('\fontsize{16} Dx')
    subplot(3,1,3)
    plot(fdatime, xarray(:,3,j), '-', [0,T], [0,0], 'r:')
    ylabel('\fontsize{16} D^2x')
    pause
end

%  reconstruct each X coordinate

subplot(1,1,1)
Zmat = squeeze(xarray(:,1,:));
for i=1:20
    coef = Zmat\fdarray(:,i,1);
    xhat = Zmat*coef;
    RMSEi = sqrt(mean((fdarray(:,i,1) - xhat).^2));
    lhdl = plot(fdatime, fdarray(:,i,1), '-', ...
                fdatime, xhat, '--', ...
                [0,T], [0,0], 'r:');
    set(lhdl, 'LineWidth', 2)
    title(['\fontsize{16} Record ',num2str(i), ...
           '  RMSE = ',num2str(round(RMSEi*1000)/1000)])
    axis([0,T,-0.05, 0.05])
    legend('\fontsize{16} Observed', ...
           '\fontsize{16} Fit', ...
           'Location', 'SouthEast')
    pause
end

%  Y - curves

Ybfdcell{1} = bfdcell{2,2,1};
Ybfdcell{2} = bfdcell{2,2,2};
Ybfdcell{3} = bfdcell{2,2,3};

ystart(1,1) = mean(eval_fd(0, fdafd(:,2), 0));
ystart(2,2) = mean(eval_fd(0, fdafd(:,2), 1));
ystart(3,3) = mean(eval_fd(0, fdafd(:,2), 2));

[tp1, yp1] = ode45(@derivcell, fdatime, ystart(:,1), odeoptions, Ybfdcell);
[tp2, yp2] = ode45(@derivcell, fdatime, ystart(:,2), odeoptions, Ybfdcell);
[tp3, yp3] = ode45(@derivcell, fdatime, ystart(:,3), odeoptions, Ybfdcell);

%  Plot solutions  The second dimension of xarray
%  corresponds to the order of derivative in the solution,
%  ranging from 0 to 2.

yarray = zeros(n,3,3);
yarray(:,:,1) = yp1;
yarray(:,:,2) = yp2;
yarray(:,:,3) = yp3;

for j=1:3
    subplot(3,1,1)
    plot(fdatime, yarray(:,1,j), '-', [0,T], [0,0], 'r:')
    ylabel('\fontsize{16} y')
    title(['\fontsize{16} Solution ',num2str(j)])
    subplot(3,1,2)
    plot(fdatime, yarray(:,2,j), '-', [0,T], [0,0], 'r:')
    ylabel('\fontsize{16} Dy')
    subplot(3,1,3)
    plot(fdatime, yarray(:,3,j), '-', [0,T], [0,0], 'r:')
    ylabel('\fontsize{16} D^2y')
    pause
end

%  reconstruct each Y coordinate

subplot(1,1,1)
Zmat = squeeze(yarray(:,1,:));
for i=1:20
    coef = Zmat\fdarray(:,i,2);
    yhat = Zmat*coef;
    RMSEi = sqrt(mean((fdarray(:,i,2) - yhat).^2));
    lhdl = plot(fdatime, fdarray(:,i,2), '-', ...
                fdatime, yhat, '--', ...
                [0,T], [0,0], 'r:');
    set(lhdl, 'LineWidth', 2)
    title(['\fontsize{16} Record ',num2str(i), ...
           '  RMSE = ',num2str(round(RMSEi*1000)/1000)])
    axis([0,T,-0.05, 0.05])
    legend('\fontsize{16} Observed', ...
           '\fontsize{16} Fit', ...
           'Location', 'SouthEast')
    pause
end

%  reconstruct the script

subplot(1,1,1)
Xmat = squeeze(xarray(:,1,:));
Ymat = squeeze(yarray(:,1,:));
for i=1:20
    coef = Xmat\fdarray(:,i,1);
    xhat = Xmat*coef;
    coef = Ymat\fdarray(:,i,2);
    yhat = Ymat*coef;
    lhdl = plot(fdarray(:,i,1),  fdarray(:,i,2),  'go', ...
                xhat,   yhat,   '-', ...
                fdameanvec(:,1), fdameanvec(:,2), 'r--');
    set(lhdl, 'LineWidth', 2)
    title(['\fontsize{16} Record ',num2str(i)])
    axis([-0.04, 0.04, -0.04, 0.04])
    legend('\fontsize{16} Observed', ...
           '\fontsize{16} Fit', ...
           '\fontsize{16} Mean', ...
           'Location', 'SouthEast')
    pause
end


