function [w] = getword(words, prob, maxWordLength)
    % Description: randomly selects a word as a function of its probability
    %
    % Inputs:
    % 1. words: a vector of words
    % 2. prob: a vector of probabilities, for each word in "words"
    % respectively
    % 3. maxWordLength: words longer than this value are not discarded
    %
    % Outputs:
    % 1. w : a word of maximal lenght maxWordLength, randomly selected from
    % the "words" list according to its probability (i.e., the higher the
    % probability, the more often a word is selected).
    %
    %
    % (c) 2011 Frdric Dandurand
    %
    totalProb = sum(prob);  % total probability (except for rounding errors, should be close to 1)
    found = false;
    
    % principle is as follows: generate a random value, and select the first word
    % for which the cumulative probability (of all words seen before,
    % including it) exceeds the random value
    while (found == false)
        val = totalProb*rand(1);  % generate a random number with max value = totalProb
        index = 1;        % index of the current word added
        cumulProb = 0.0;      % total cumulative probability of words [1..index]
        while (cumulProb < val)  % continue adding words while the cumulative probability is below the random number
            w = words(index); % current word considered
            cumulProb = cumulProb + prob(index);  % update cumulative probability
            index = index + 1;  % update index
        end
        
        % when the loop exists, w is the target word
        % verify that this word is not too long (i.e., fits in the slot)
        if (size(str2mat(w),2) <= maxWordLength)
            % yes, word is short enough, use it
            found = true;
        end
    end
end
