function [ dataPatterns ] = computeMaps(dataPatterns)
    % Description: computes the stack of hard-coded maps
    %
    % Inputs:
    % 1. dataPatterns : array of data patterns. Each data pattern must
    % contain a field maps(1).data, which is a 2D matrix of retinal image
    % values. Typically, each pattern in the array is a different letter.
    %
    % Outputs:
    % 1. dataPatterns : array of data patterns based on the input, and
    % augmented with maps 2 (contrasts),3 (lines) and 4 (angles). Each map
    % had two fields: a diplayable label, and a 2D data matrix.
    %
    %
    % (c) 2011 Frdric Dandurand
    %
    for i = 1 : length(dataPatterns)
        % process each letter pattern
        disp(['Processing pattern ', int2str(i), ' (', dataPatterns(i).label, ')'])

        % compute contrasts based data in maps(1) i.e., retinal image 
        dataPatterns(i).maps(2).data = extractContrasts(dataPatterns(i).maps(1).data);
        dataPatterns(i).maps(2).label = 'Contrasts';  % informative label
        % compute lines based data in maps(2) i.e., lines
        dataPatterns(i).maps(3).data = extractLines(dataPatterns(i).maps(2).data);
        dataPatterns(i).maps(3).label = 'Lines'; % informative label
        % compute angles based data in maps(3) i.e., lines 
        dataPatterns(i).maps(4).data = extractAngles(dataPatterns(i).maps(3).data);
        dataPatterns(i).maps(4).label = 'Angles'; % informative label
    end
end