function [ contMap ] = extractContrasts (map)
    % Description: generates a map of contrasts (on center, off surround)
    %
    % Inputs:
    % 1. map : a 2D map of raw pixels
    %
    % Outputs:
    % 1. contMap : map of contrasts
    %
    % (c) 2011 Frdric Dandurand
    %
    
    % bigMap is used to avoid edge problems. It is one pixel wider than the
    % original map at each edge, and contains zero values, so will not
    % affect contrasts detected.
    bigMap = zeros(size(map)+2);
    bigMap(2:1+size(map,1), 2:1+size(map,2)) = map;
    
    posFactor = 1.0;  % on center
    negFactor = posFactor / 4;  % off surround (4 pixels up,down,left,right)
    
    contMap = zeros(size(map));
    for i = 2:size(bigMap, 1)-1
        for j = 2:size(bigMap, 2)-1
            % negative contribution of 4 pixels (up,down,left,right)
            neg = bigMap(i-1,j)+bigMap(i+1,j)+bigMap(i,j-1)+bigMap(i,j+1);
            pos = bigMap(i,j);  % on center contribution
            contMap(i-1,j-1) = posFactor * pos - negFactor * neg;
        end
    end
return