function [ lines ] = extractLines (map)
    % Description: Converts contrasts into a 3 dimension array of line information
    % the first 2 dimensions preserve topological information from the
    % contrasts array, and the 3rd one has 4 levels, one for each type of
    % line
    % index 0 = horizontal
    %   "   1 = vertical
    %   "   2 = forward slash
    %   "   3 = backward slash
    %
    % Inputs:
    % 1. map : a 2D matrix of contrast values for pixels
    %
    % Outputs:
    % 1. lines: a 3D matrix of lines
    %
    % (c) 2011 Frdric Dandurand
    %

    lineConstants;
    
    % bigMap is used to avoid edge problems. 
    %
    bigMap(2:1+size(map,1), 2:1+size(map,2)) = map;

    lines = zeros(size(map,1), size(map,2), 4);
    for i = 2:size(bigMap, 1)-1
        for j = 2: size(map, 2)-1
            % divide by 3 for scaling (because you need three points to form a line) 

            % Check if horizontal, vertical or diagonal line for which 
            % this pixel is the center; i.e. 
            % Horizontal: *x*
            lines(i-1,j-1,HORIZ_INDEX) = sum(bigMap(i, j-1:j+1))/3;
            % vertical:   *
            %             x
            %             *
            lines(i-1,j-1,VERT_INDEX) = sum(bigMap(i-1:i+1, j))/3;
            % forward slash: *
            %            x
            %           *
            lines(i-1,j-1,FS_INDEX) = (bigMap(i-1, j+1) +  bigMap(i,j) + bigMap(i+1, j-1))/3;
            % Back slash: *
            %              x
            %               *
            lines(i-1,j-1,BS_INDEX) = (bigMap(i-1, j-1) +  bigMap(i,j) + bigMap(i+1, j+1))/3;
        end
    end
return