function [ lettersData ] = getLettersData (root)
    % Description: loads letter data files in the root directory 
    %
    % Inputs:
    % 1. root: directory where letter data files are located
    %
    % Outputs:
    % 1. lettersData: array (one element per data file) of structures containing:
    %          id   : letter type 
    %          label: letter details (font, etc.)
    %          maps(1).data : 2D matrix of pixel values (retinal image)
    %          maps(1).label : title label of the map
    %
    % (c) 2011 Frdric Dandurand
    %

    lettersData = [];
    files = dir(root);  % list content of the directory
    %skip first two "files" which are current (.) and parent (..) directories
    for fileId = 3: length(files)
        letterData = load([root files(fileId).name]);  % concatenate the full path+file name
        lettersId = files(fileId).name;    % file name with details

        id = files(fileId).name(1);   % first character is the type of letter (A, B, ...)

        lettersData(fileId-2).id = id;                       % set letter label
        lettersData(fileId-2).label = lettersId;             % letter details (font, etc.)
        lettersData(fileId-2).maps(1).data = letterData;     % 2D matrix of pixel values
        lettersData(fileId-2).maps(1).label = 'retinal image';  % add retinal image label 
    end
end
