function viewmap (maps, include)
    % Description: plots (displayed) stacked maps of letter data
    %
    % Inputs:
    %   1. maps:  array of N elements:
    %       label: string that indicates a title for the map
    %       data: 2D or 3D of data to be displayed
    %
    %       Note: recall that order of maps is as follows:
    %         map no 1. : retinal image
    %         map no 2. : contrasts
    %         map no 3. : lines
    %         map no 4. : angles
    %         map no 5. : self-oganized map (of angles usually)
    %   2. include: a vector of binary values indicating which of the maps to
    %      display (e.g., [1 1 0 0 1] to display maps no. 1,2 and 5)
    %
    % (c) 2011 Frdric Dandurand
    %

    clf;  % clear the figure
    
    % verify that there maps indicated in the "include" vector exist
    if (size(maps,2) < size(include,2))
        error('Vector indicating which maps to plot contains more items than the number of maps that can be displayed')
    end
    total = size(find(include),2);  % number of ones in the include vector indicates how many subplots
    posId = 1;  % keeps track of the position on the display where to put the next map
    for mapId = 1:size(include,2)
        % for each map, check if it should be included
        if (include(mapId) == true)
             % for maps to be included, plot on a subplot at posId
             % viewmatrix does the actual plotting, at the location
             % specified by subplot
             subplot(total, 1, posId)
             viewmatrix(maps(mapId).data, ['Map ', num2str(mapId), ': ', maps(mapId).label])
             posId = posId + 1;  % next plot at the step position
        end
    end
return
