function viewmatrix(x, label)
    % Description:
    % displays a 2D matrix of numbers in a color coded fashion.
    % Dark blue = small --> Red = large
    %
    % Inputs:
    % x     : a 2D matrix of values 
    % label : title (label) of the plot
    %
    % (c) 2011 Frdric Dandurand

    [numrow,numcol] = size(x); % number of rows and columns of the matrix x
    % if the matrix has 3 dimensions (e.g., cortical columns), the size 
    % operator automatically converts to a 2D matrix where the different
    % layers are concatenated side by side.

    for i = 1:numrow
        for k = 1:numcol
            x0 = [k-1,k];       % column index for background box
            y0 = [i-1,i];       % row index for background box
            z0 = zeros(length(x0),length(y0)); % zeros matrix to plot surface
            plotValue = x(numrow+1-i,k);

            % To plot the background color boxes
            surface(x0, y0, z0, plotValue);
        end
    end
    axis equal          % make axis of the plot equal
    box on              % make border line of the plot visible
    axis off            % make the axis numbers and lines invisible
    title(label)
    