function [clipped] = clipMatrix (matrix, minVal, maxVal, debug)
    % Description: in the matrix, clip every values below minVal at minVal
    % and above maxVal at maxVal
    %
    % Inputs:
    % 1. matrix: a 2D or 3D matrix of values
    % 2. minVal: low clipping value
    % 3. maxVal: high clipping value
    % 4. dbug: flag for debug mode
    %
    % Outputs:
    % 1. clipped: matrix of same size as input matrix, with all values
    % within range [minVal,maxVal]
    %
    %
    % (c) 2011 Frdric Dandurand
    %
    
    clipped = max(matrix, minVal);  % clipping low values to minVal
    clipped = min(clipped, maxVal); % clipping high values to maxVal
    
    if (debug)
        % matrix of same size
        clipped2 = zeros(size(matrix));
        
        if (size(size(matrix),2) == 2)
            % 2D matrix
            for i=1:size(matrix,1)
                for j=1:size(matrix,2)
                    % clip element by element, across two dimensions i,j
                    clipped2(i,j) = max(matrix(i,j), minVal);
                    clipped2(i,j) = min(clipped2(i,j), maxVal);
                end
            end
        elseif (size(size(matrix),2) == 3)
            % 3D matrix
            for i=1:size(matrix,1)
                for j=1:size(matrix,2)
                    for k=1:size(matrix,3)
                        % clip element by element, across three dimensions
                        % i,j,k
                        clipped2(i,j,k) = max(matrix(i,j,k), minVal);
                        clipped2(i,j,k) = min(clipped2(i,j,k), maxVal);
                    end
                end
            end
        else
            error('clipMatrix error: matrix size not supported in debug mode')
        end
        
        % make sure methods are consistent (differences are within a small
        % tolerance)
        testDiff(clipped, clipped2);
    end
